﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using ConfigurationTool;
using ConfigurationTool.Config;
using ConfigurationTool.ConfigMultiple;

using Test_ConfigurationTool.Entities;

namespace Test_ConfigurationTool
{
    [TestClass]
    public class ConfigurationTest
    {
        /// <summary>
        /// Проверка базового конфига
        /// </summary>
        [TestMethod]
        public void Test1()
        {
            string file = @"Config.xml";

            var conf = new ConfigurationManager<Config1>(new ConfigParams()
            {
                ConfigFile = file,
                Format = EnumFormat.XML,
                UseApplicationPathPrefix = false
            });

            conf.Data = Config1.GetConfig_1();
            conf.Export();
            if (!conf.Exist())
                throw new Exception();

            conf.Import();
            if (conf.Data != Config1.GetConfig_1())
                throw new Exception();

            conf.Delete();
        }

        /// <summary>
        /// Проверка конфига с кастомным сериализатором
        /// </summary>
        [TestMethod]
        public void Test2()
        {
            string file = @"Config2.xml";

            var conf = new ConfigurationManager<Config2>(new ConfigParams()
            {
                ConfigFile = file,
                Format = EnumFormat.XML,
                UseApplicationPathPrefix = false
            });

            for (int i = 0; i < 2; i++)
            {
                conf.Data.Dictionary.Add(i, new SubEntity()
                {
                    ID = i,
                    Name = "Name " + i
                });
            }

            conf.Export();

            conf.Delete();
        }

        /// <summary>
        /// Проверка конфига с множественными файлами
        /// </summary>
        [TestMethod]
        public void Test3()
        {
            var conf = new MConfigurationManager<Config3>(new MConfigParams()
            {
                ConfigDirectory = "Configs3",
                Format = EnumFormat.XML,
                UseApplicationPathPrefix = false
            });

            for (int i = 0; i < 2; i++)
            {
                conf.Add(i.ToString(), new Config3()
                {
                    ID = i,
                    Name = "name" + i,
                    Date = DateTime.Now
                });
            }

            conf.Delete();
        }

    }
}
