﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using SingletonTool;

namespace ConfigurationTool
{      
    //Обеспечивате доступ к конфигу
    public sealed class ConfigurationManager<T>
        where T:new()
    {
        //Конфиг
        private ConfigEntity<T> Config => SignlethonWithParams<ConfigEntity<T>, ConfigParams>.Get();
        //Данные конфига
        public T Data => Config.Data;

        //При первом обращении необходимо использовать данный конструктор для иницилизации параметров конфига
        public ConfigurationManager(ConfigParams param)
        {
            if (!SignlethonWithParams<ConfigEntity<T>, ConfigParams>.ExistInstance)
                SignlethonWithParams<ConfigEntity<T>, ConfigParams>.Create(param);
        }

        //Для повторных обращений к конфигу
        public ConfigurationManager()
        {
            if (!SignlethonWithParams<ConfigEntity<T>, ConfigParams>.ExistInstance)
                throw new Exception("Use ConfigurationManager(ConfigParams param) first");
        }


        //Прочитать из файла
        public void Import()
        {
            Config.Import();
        }
        //Сохранить в файл
        public void Export()
        {
            Config.Export();
        }

    }
}
