﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using ConfigurationTool.Serializer;
using SingletonTool;

namespace ConfigurationTool
{
    //Singlethon сущность конфига 
    public class ConfigEntity<T>
        : ISignlethonWithParams<ConfigParams>
        where T : class, new()
    {
        //Параметры конфига
        public ConfigParams Params { private set; get; }

        //Объект сериализации
        private ISerializer<T> Serializer;

        //Данные, хранимые в конфиге
        public T Data { set; get; } = new T();

        public void SetParams(ConfigParams param)
        {
            Params = param;

            switch (param.Format)
            {
                case EnumFormat.XML: Serializer = new XMLSerializer<T>(); break;
                case EnumFormat.Binary: Serializer = new BinarySerializer<T>(); break;
            }

            if (File.Exists(Params.ConfigPath))
                Import();
            Export();
        }

        //Прочитать файл
        public void Import()
        {
            Data = Serializer.Import(Params.ConfigPath);
        }
        //Сохранить в файл
        public void Export()
        {
            Serializer.Export(Data, Params.ConfigPath);
        }
    }
}
