﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

namespace ConfigurationTool.Serializer
{
    class BinarySerializer<T>
        : ISerializer<T>
        where T : class, new()
    {

        public T Import(string file)
        {
            if (typeof(T).GetInterface("ICustomSerialazible") == null)
            {
                // передаем в конструктор тип класса
                BinaryFormatter formatter = new BinaryFormatter();

                // десериализация
                using (FileStream fs = new FileStream(file, FileMode.Open))
                {
                    return (T)formatter.Deserialize(fs);
                }
            }
            else
            {
                ICustomSerialazible res = (ICustomSerialazible)new T();

                // передаем в конструктор тип класса
                BinaryFormatter formatter = new BinaryFormatter();

                // десериализация
                using (FileStream fs = new FileStream(file, FileMode.Open))
                {
                    res.Import(formatter.Deserialize(fs));
                }

                return (T)res;
            }
        }

        public void Export(T data, string file)
        {
            if (typeof(T).GetInterface("ICustomSerialazible") == null)
            {
                // передаем в конструктор тип класса
                BinaryFormatter formatter = new BinaryFormatter();

                // получаем поток, куда будем записывать сериализованный объект
                using (FileStream fs = new FileStream(file, FileMode.Create))
                {
                    formatter.Serialize(fs, data);
                }
            }
            else
            {
                ICustomSerialazible entity = (ICustomSerialazible)data;

                // передаем в конструктор тип класса
                BinaryFormatter formatter = new BinaryFormatter();

                // получаем поток, куда будем записывать сериализованный объект
                using (FileStream fs = new FileStream(file, FileMode.Create))
                {
                    formatter.Serialize(fs, entity.Export());
                }
            }
        }


        public T Import(Stream stream)
        {
            if (typeof(T).GetInterface("ICustomSerialazible") == null)
            {
                // передаем в конструктор тип класса
                BinaryFormatter formatter = new BinaryFormatter();

                // десериализация                
                return (T)formatter.Deserialize(stream);
            }
            else
            {
                ICustomSerialazible res = (ICustomSerialazible)new T();

                // передаем в конструктор тип класса
                BinaryFormatter formatter = new BinaryFormatter();

                // десериализация
                res.Import(formatter.Deserialize(stream));

                return (T)res;
            }
        }

        public void Export(T data, Stream stream)
        {
            if (typeof(T).GetInterface("ICustomSerialazible") == null)
            {
                // передаем в конструктор тип класса
                BinaryFormatter formatter = new BinaryFormatter();

                formatter.Serialize(stream, data);
            }
            else
            {
                ICustomSerialazible entity = (ICustomSerialazible)data;

                // передаем в конструктор тип класса
                BinaryFormatter formatter = new BinaryFormatter();

                formatter.Serialize(stream, entity.Export());
            }
        }
    }
}
