﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Xml.Serialization;

using ConfigurationTool;

namespace ConfigurationTool.Serializer
{
    class XMLSerializer<T>
        : ISerializer<T>
        where T : class, new()
    {
        public T Import(string file)
        {
            var a = typeof(T).GetInterfaces();
            var b = typeof(T).GetInterface("ICustomSerialazible");

            if (typeof(T).GetInterface("ICustomSerialazible") == null)
            {
                // передаем в конструктор тип класса
                XmlSerializer formatter = new XmlSerializer(typeof(T));

                // десериализация
                using (FileStream fs = new FileStream(file, FileMode.Open))
                {
                    return (T)formatter.Deserialize(fs);
                }
            }
            else
            {
                ICustomSerialazible res = (ICustomSerialazible)new T();

                // передаем в конструктор тип класса
                XmlSerializer formatter = new XmlSerializer(res.SerialazibleType);

                // десериализация
                using (FileStream fs = new FileStream(file, FileMode.Open))
                {
                    res.Import(formatter.Deserialize(fs));
                }

                return (T)res;
            }
        }

        public void Export(T data, string file)
        {
            if (typeof(T).GetInterface("ICustomSerialazible") == null)
            {
                // передаем в конструктор тип класса
                XmlSerializer formatter = new XmlSerializer(typeof(T));

                // получаем поток, куда будем записывать сериализованный объект
                using (FileStream fs = new FileStream(file, FileMode.Create))
                {
                    formatter.Serialize(fs, data);
                }
            }
            else
            {
                ICustomSerialazible entity = (ICustomSerialazible)data;

                // передаем в конструктор тип класса
                XmlSerializer formatter = new XmlSerializer(entity.SerialazibleType);

                // получаем поток, куда будем записывать сериализованный объект
                using (FileStream fs = new FileStream(file, FileMode.Create))
                {
                    formatter.Serialize(fs, entity.Export());
                }
            }
        }


        public T Import(Stream stream)
        {
            if (typeof(T).GetInterface("ICustomSerialazible") == null)
            {
                // передаем в конструктор тип класса
                XmlSerializer formatter = new XmlSerializer(typeof(T));

                // десериализация
                return (T)formatter.Deserialize(stream);
            }
            else
            {
                ICustomSerialazible res = (ICustomSerialazible)new T();

                // передаем в конструктор тип класса
                XmlSerializer formatter = new XmlSerializer(res.SerialazibleType);

                // десериализация                
                res.Import(formatter.Deserialize(stream));

                return (T)res;
            }
        }

        public void Export(T data, Stream stream)
        {
            if (typeof(T).GetInterface("ICustomSerialazible") == null)
            {
                // передаем в конструктор тип класса
                XmlSerializer formatter = new XmlSerializer(typeof(T));
      
                formatter.Serialize(stream, data);
            }
            else
            {
                ICustomSerialazible entity = (ICustomSerialazible)data;

                // передаем в конструктор тип класса
                XmlSerializer formatter = new XmlSerializer(entity.SerialazibleType);
         
                formatter.Serialize(stream, entity.Export());
            }
        }
    }
}
