﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using ConfigurationTool;

namespace Console
{  
    public class ConfigData : ICustomSerialazible
    {
        public class ConfigData_Serial
        {
            public class Item
            {
                public int Key { set; get; }
                public string Value { set; get; }
            }

            public string Name { set; get; }
            public int ID { set; get; }


            public List<Item> dictionary { set; get; }
        }

        public string Name { set; get; } = "n";
        public int ID { set; get; } = 23;

        public Dictionary<int, string> dictionary { set; get; } = new Dictionary<int, string>
        {
            [1]="1",
            [2]="2"
        };

        public Type SerialazibleType => typeof(ConfigData_Serial);

        public object Export()
        => new ConfigData_Serial()
            {
                ID = ID,
                Name = Name,
                dictionary = dictionary
                    .Select(e => 
                        new ConfigData_Serial.Item()
                        {
                            Key = e.Key,
                            Value = e.Value
                        }
                    )
                .ToList()
            };

        public void Import(object obj)
        {
            ConfigData_Serial data = (ConfigData_Serial)obj;

            ID = data.ID;
            Name = data.Name;

            dictionary = data.dictionary
                .ToDictionary(e => e.Key, e2 => e2.Value);
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            var conf = new ConfigurationManager<ConfigData>(new ConfigParams()
            {
                ConfigFile = "Config.xml",
                Format = EnumFormat.XML,
                UseApplicationPathPrefix = true
            });

        }
    }
}
