﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using RW_Tool.Core;
using RW_Tool.Core.Abstract;
using RW_Tool.DataSource.FileOrStream; 

using RW_Tool.XML_BIN.RW_BIN;
using RW_Tool.XML_BIN.RW_XML;

namespace RW_Tool.XML_BIN
{
    public class Factory<T>
        where T : class, new()
    {
        public RW_Service<T, DS_FileOrStream> GetRW(EnumFormat format, DS_FileOrStream ds = null)
        {
            switch (format)
            {
                case EnumFormat.XML: return GetXMLRW(ds);
                case EnumFormat.Bin: return GetBinRW(ds);

                default: throw new Exception();
            }
        }


        public RW_Service<T, DS_FileOrStream> GetXMLRW(DS_FileOrStream ds = null)
        =>
             new RW_Service<T, DS_FileOrStream>
                (
                ds,
                new XML_Reader<T>(),
                new XML_Writer<T>()
                );

        public RW_Service<T, DS_FileOrStream> GetBinRW(DS_FileOrStream ds = null)
        =>
             new RW_Service<T, DS_FileOrStream>
                (
                ds,
                new Bin_Reader<T>(),
                new Bin_Writer<T>()
                );

    }

    public class Factory<T1, T3>
        where T1 : class, new()
        where T3 : class, new()
    {
        public RW_Custom_Service<T1, DS_FileOrStream, T3> GetRW(EnumFormat format, ITransformator<T1, T3> transformator, DS_FileOrStream ds = null)
        {
            switch (format)
            {
                case EnumFormat.XML: return GetXMLRW(transformator, ds);
                case EnumFormat.Bin: return GetBinRW(transformator, ds);

                default: throw new Exception();
            }
        }


        public RW_Custom_Service<T1, DS_FileOrStream, T3> GetXMLRW(ITransformator<T1, T3> transformator, DS_FileOrStream ds = null)
        =>
             new RW_Custom_Service<T1, DS_FileOrStream, T3>
                (
                ds,
                transformator,
                new XML_Reader<T3>(),
                new XML_Writer<T3>()
                );

        public RW_Custom_Service<T1, DS_FileOrStream, T3> GetBinRW(ITransformator<T1, T3> transformator, DS_FileOrStream ds = null)
        =>
             new RW_Custom_Service<T1, DS_FileOrStream, T3>
                (
                ds,
                transformator,
                new Bin_Reader<T3>(),
                new Bin_Writer<T3>()
                );

    }

}
