﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using RW_Tool.Core.Abstract;

namespace Test.ConfigurationTool.Entities
{

    public class SubEntity
    {
        public int ID { set; get; }
        public string Name { set; get; }
    }


    public class Config2
    {
        public class Transformator : ITransformator<Config2, Config2_Serial>
        {
            public Config2 ToEntityT1(Config2_Serial entity)
            {
                return new Config2()
                {
                    Dictionary = entity
                        .Dictionary
                        .ToDictionary(e => e.ID)
                };
            }

            public Config2_Serial ToEntityT2(Config2 entity)
            {
                return new Config2_Serial()
                {
                    Dictionary = entity.Dictionary
                    .Values
                    .ToList()
                };
            }
        }

        public Dictionary<int, SubEntity> Dictionary { set; get; } 
            = new Dictionary<int, SubEntity>();
    }

    public class Config2_Serial
    {
        public List<SubEntity> Dictionary { set; get; } = new List<SubEntity>();
    }
}
