﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using RW_Tool.Core.Abstract;
using RW_Tool.XML_BIN;

using Tools.ConfigurationTool.Config;
using Tools.ConfigurationTool.Config.Custom;
using Tools.ConfigurationTool.ConfigMultiple;

using Test.ConfigurationTool.Entities;

namespace Test.ConfigurationTool
{
    [TestClass]
    public class ConfigurationTest
    {
        /// <summary>
        /// Проверка базового конфига
        /// </summary>
        [TestMethod]
        public void Test1()
        {
            string file = @"Config.xml";

            var conf = new ConfigurationManager<Config1>(new ConfigParams(file)
            {
                Format = EnumFormat.XML,
                UseApplicationPathPrefix = false
            });

            conf.Data = Config1.GetConfig_1();
            conf.Export();
            if (!conf.FileExist())
                throw new Exception();

            conf.Import();
            if (conf.Data != Config1.GetConfig_1())
                throw new Exception();

            conf.Delete();
        }

        /// <summary>
        /// Проверка конфига с кастомным сериализатором
        /// </summary>
        [TestMethod]
        public void Test2()
        {
            string file = @"Config2.xml";

            var conf = new ConfigurationManager<Config2, Config2_Serial>(
                new ConfigParams<Config2, Config2_Serial>(file, new Config2.Transformator())
            {
                Format = EnumFormat.XML,
                UseApplicationPathPrefix = false
            });

            for (int i = 0; i < 2; i++)
            {
                conf.Data.Dictionary.Add(i, new SubEntity()
                {
                    ID = i,
                    Name = "Name " + i
                });
            }

            conf.Export();

            conf.Delete();
        }

        /// <summary>
        /// Проверка конфига с множественными файлами
        /// </summary>
        [TestMethod]
        public void Test3()
        {
            var conf = new MConfigurationManager<Config3>(new MConfigParams("Configs3")
            {
                Format = EnumFormat.XML,
                UseApplicationPathPrefix = false
            });

            for (int i = 0; i < 2; i++)
            {
                conf.AddAndSave(i.ToString(), new Config3()
                {
                    ID = i,
                    Name = "name" + i,
                    Date = DateTime.Now
                });
            }

            conf.Delete();
        }

    }
}
