﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using Tools.ConfigurationTool.Config.Base;

namespace Tools.ConfigurationTool.Config
{
    //Singlethon сущность конфига 
    internal class ConfigEntity<T> 
        : BaseConfigEntity<T, ConfigParams>        
        where T : class, new()
    {
        public override void SetParams(ConfigParams param)
        {
            base.SetParams(param);

            if (File.Exists(Params.ConfigPath))
            {
                Import();
            }
            Export();
        }
        
        protected override T Read()
        {
            return Params
                .RW_Factory
                .Get_RW<T>(Params.ConfigPath, Params.Format)
                .Read();
        }

        protected override void Write(T data)
        {
            Params
                .RW_Factory
                .Get_RW<T>(Params.ConfigPath, Params.Format)
                .Write(Data);
        }
    }
}
