﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Xml;

namespace Tools.XMLExtensions
{
    public static class XmlDoc_Extensions
    {
        /// <summary>
        /// Пространство имен по умолчанию
        /// </summary>
        /// <param name="NS_Prefix">Префикс для пространства</param>
        public static XmlNamespaceManager DefaultNamespace(this XmlDocument doc, string NS_Prefix = "x")
        {
            XmlNamespaceManager nsmgr = new XmlNamespaceManager(doc.NameTable);
            nsmgr.AddNamespace(NS_Prefix, doc.DocumentElement.NamespaceURI);
            return nsmgr;
        }

        /// <summary>
        /// Выполнить XPath запрос используя стандартное пространство имен 
        /// </summary>
        /// <param name="XPath"></param>
        /// <param name="NS_Prefix">Префикс для пространства</param>
        public static List<XmlNode> SelectNodes_WithNS(this XmlNode xelem, string XPath, string NS_Prefix = "x")
        {
            return xelem
                .SelectNodes(XPath, xelem.OwnerDocument.DefaultNamespace(NS_Prefix))
                .ToList();
        }


        /// <summary>
        /// Преобразование в List
        /// </summary>
        public static List<XmlNode> ToList(this XmlNodeList xelems)
        {
            List<XmlNode> res = new List<XmlNode>(xelems.Count);

            foreach (XmlNode elem in xelems)
            {
                res.Add(elem);
            }

            return res;
        }


        /// <summary>
        /// Путь от корня документа
        /// </summary>
        public static List<XmlNode> Path(this XmlNode xelem)
        {
            List<XmlNode> res = new List<XmlNode>();

            for (XmlNode elem = xelem; elem != null; elem = elem.ParentNode)
            {
                res.Add(elem);
            }

            res.Reverse();
            return res;
        }

        /// <summary>
        /// Путь от корня документа
        /// </summary>
        /// <param name="split">Символ разделитель</param>
        public static string PathString(this XmlNode xelem, char split = '\\')
        {
            StringBuilder res = new StringBuilder();

            xelem.Path()
                .ForEach(e => res.Append(split + e.LocalName));

            return res.ToString();
        }

    }
}
