﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using RW_Tool.Core.Abstract;

namespace RW_Tool.Core
{
    /// <summary>
    /// Обертка для чтения/записи какой либо сущности в какое либо хранилище
    /// с использованием промежуточной сущности T3
    /// </summary>
    /// <typeparam name="T1">Тип сущности</typeparam>
    /// <typeparam name="T2">Параметры</typeparam>
    /// <typeparam name="T3">Тип сериализуемой сущности</typeparam>
    public class RW_Custom<T1,T2,T3>:
        I_RW<T1, T2>
        where T3 : new()
    {
        public T2 DataStorage { protected set; get; }
        public bool HaveDataStorage => DataStorage != null;

        public ITransformator<T1, T3> Transformator { protected set; get; }


        public readonly IReader<T3, T2> Reader;
        public bool HaveReader => Reader != null;

        public readonly IWriter<T3, T2> Writer;
        public bool HaveWriter => Writer != null;



        public RW_Custom(
            ITransformator<T1, T3> Transformator,
            IReader<T3, T2> Reader,
            IWriter<T3, T2> Writer
            )
        {
            this.Transformator = Transformator;
            this.Reader = Reader;
            this.Writer = Writer;
        }
        public RW_Custom(
            T2 ds,
            ITransformator<T1, T3> Transformator,
            IReader<T3, T2> Reader,
            IWriter<T3, T2> Writer
            )
        {
            DataStorage = ds;
            this.Transformator = Transformator;
            this.Reader = Reader;
            this.Writer = Writer;
        }


        public T1 Read(T2 param)
        {
            if (!HaveReader)
                throw new Exception();

            T3 serial_entity = Reader.Read(param);
            return Transformator.ToEntityT1(serial_entity);            
        }
        public T1 Read() => Read(DataStorage);

        public void Write(T1 entity, T2 param)
        {
            if (!HaveWriter)
                throw new Exception();

            T3 serial_entity = Transformator.ToEntityT2(entity);
            Writer.Write(serial_entity, param);             
        }
        public void Write(T1 entity) => Write(entity, DataStorage);
    }
}
