﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Tools.ConfigurationTool.ConfigMultiple.Base
{
    internal interface IMConfigEntity<D>
    {
        Dictionary<string, D> Data { set; get; }


        /// <summary>
        /// Сохранить в папку конфига указанную запись
        /// </summary>
        /// <param name="key">ключ</param>
        void Export(string key);
        /// <summary>
        /// Очистить папку и сохранить
        /// </summary>
        void ExportAll();

        /// <summary>
        /// Прочитать запись по указанному пути (key - имя файла)
        /// </summary>
        /// <param name="path"></param>
        void Import(string path);
        /// <summary>
        /// Прочитать все значения из папк конфигурации
        /// </summary>
        void ImportAll();


        /// <summary>
        /// Добавить значение в конфиг и сохранить в папку
        /// </summary>
        /// <param name="key">ключ</param>
        /// <param name="value">запись</param>
        void AddAndSave(string key, D value);
        /// <summary>
        /// Удалить значение из конфига и из папки
        /// </summary>
        /// <param name="key">ключ</param>
        void RemoveAndSave(string key);


        void DeleteDirectory();
    }
}
