﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Threading.Tasks;
using System.Collections.Generic;
using System.Linq;

using Tools.Collections.Concurrent.AsyncBuffer;
using Tools.Collections.Concurrent.AsyncBuffer.Store;
using Tools.Collections.Concurrent.AsyncBuffer.PriorityWrapper;

namespace Tools.Collections.Concurrent.AsyncBuffer.UnitTest.Fake
{
    enum EnumTestPrioriry
    {
        Low = 0,
        MiddleLow = 25,
        Middle = 50,
        MiddleHish = 75,
        High = 100
    }

    class PriorityComparer
        : IComparer<EnumTestPrioriry>
    {
        public Func<EnumTestPrioriry, EnumTestPrioriry,int> CompareFunc { set; get; }
        public int Compare(EnumTestPrioriry x, EnumTestPrioriry y)
        {
            if (x > y)
            {
                return -1;
            }
            if (x < y)
            {
                return 1;
            }

            return 0;
        }
    }
}
