﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Threading.Tasks;
using System.Collections.Generic;
using System.Linq;

using Tools.Collections.Concurrent.AsyncBuffer;
using Tools.Collections.Concurrent.AsyncBuffer.Store;
using Tools.Collections.Concurrent.AsyncBuffer.PriorityWrapper;

namespace Tools.Collections.Concurrent.AsyncBuffer.UnitTest
{
    [TestClass]
    public class StoreTest
    {
        
        [TestMethod]
        public void TestQueueStore()
        {
            IConcurrentStore<string> store = new QueueStore<string>();

            for (int i = 0; i < Settings.Count; i++)
            {
                store.Add(i.ToString());
            }

            while (store.Size != 0)
            {
                store.TryTake(out string s);
            }
        }

        [TestMethod]
        public void TestStackStore()
        {
            IConcurrentStore<string> store = new StackStore<string>();

            for (int i = 0; i < Settings.Count; i++)
            {
                store.Add(i.ToString());
            }

            while (store.Size != 0)
            {
                store.TryTake(out string s);
            }
        }

        [TestMethod]
        public void TestBagStore()
        {
            IConcurrentStore<string> store = new BagStore<string>();

            for (int i = 0; i < Settings.Count; i++)
            {
                store.Add(i.ToString());
            }

            while (store.Size != 0)
            {
                store.TryTake(out string s);
            }
        }       

    }
}
