﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;
using System.Collections.Concurrent;
using System.Collections.Specialized;
using System.Collections.ObjectModel;

namespace Tools.Collections.Concurrent.AsyncBuffer.Store
{
    public class QueueStore<T>
        : IConcurrentStore<T>
    {
        public readonly ConcurrentQueue<T> Storage 
            = new ConcurrentQueue<T>();

        private int _Size;
        public int Size
            => _Size;

        public event Action<IConcurrentStore<T>, T> OnItemAdded;
        public event Action<IConcurrentStore<T>> OnEmpty;

        public int Add(T data)
        {
            Storage.Enqueue(data);
            Interlocked.Increment(ref _Size);
            OnItemAdded?.Invoke(this, data);

            return _Size;
        }

        public bool TryTake(out T data)
        {
            if (Storage.TryDequeue(out data)) 
            {
                Interlocked.Decrement(ref _Size);

                if (_Size == 0)
                {
                    OnEmpty?.Invoke(this);
                }

                return true;
            }

            return false;
        }

        public IEnumerable<T> AsIEnumerable()
        {
            return Storage;
        }
        public void ForEach(Action<T> action)
        {
            foreach (var elem in Storage)
            {
                action(elem);
            }
        }
    }    
    
}
