﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Collections.Immutable;

namespace Tools.Collections.Concurrent
{
    public class ObjectLinkContainer<TData, TObject>
    {
        /// <summary>
        /// Данные, доступные по ключу
        /// </summary>
        public TData Data { internal set; get; }

        /// <summary>
        /// Множество объектов, которые ссылаются на эти данные
        /// </summary>
        public ImmutableHashSet<TObject> Objects { internal set; get; }


        internal ObjectLinkContainer() { }

    }


    internal class ContainerBuilder<TData, TObject>
    {
        private ObjectLinkContainer<TData, TObject> Container;


        public ContainerBuilder()
        {
            Container = new ObjectLinkContainer<TData, TObject>();
        }
        public ContainerBuilder(ObjectLinkContainer<TData, TObject> container)
        {
            Container = container;
        }


        public ContainerBuilder<TData, TObject> AddObject(TObject obj)
        {
            Container = new ObjectLinkContainer<TData, TObject>()
            {
                Objects = Container.Objects.Add(obj),
                Data = Container.Data
            };

            return this;
        }
        public ContainerBuilder<TData, TObject> RemoveObject(TObject obj)
        {
            Container = new ObjectLinkContainer<TData, TObject>()
            {
                Objects = Container.Objects.Remove(obj),
                Data = Container.Data
            };

            return this;
        }
        public ContainerBuilder<TData, TObject> UpdateData(TData data)
        {
            Container = new ObjectLinkContainer<TData, TObject>()
            {
                Objects = Container.Objects,
                Data = data
            };

            return this;
        }

        public ObjectLinkContainer<TData, TObject> Result()
        {
            return Container;
        }
    }
}