﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Tools.Collections.Concurrent.Extensions
{
    public interface IValueWrapper<TValue>
    {
        TValue Value { get; }
    }

    public sealed class RealItemWrapper<TValue>
        : IValueWrapper<TValue>
    {
        public TValue Value { private set; get; }


        public RealItemWrapper(TValue value)
        {
            Value = value;
        }

        public override int GetHashCode()
        {
            return Value.GetHashCode();
        }

        public override bool Equals(object obj)
        {
            switch (obj)
            {
                case null:
                    return false;

                case RealItemWrapper<TValue> item:
                    return
                        Value.Equals(item.Value);

                case RemoveExpressionItem<TValue> item:
                    return
                        item.NeedRemoveExpression(this);

                default:
                    return false;
            }
        }

    }

    internal sealed class RemoveExpressionItem<TValue> 
        : IValueWrapper<TValue>
    {
        public TValue Value => default(TValue);

        public Func<IValueWrapper<TValue>, bool> NeedRemoveExpression { private set; get; }


        public RemoveExpressionItem(Func<IValueWrapper<TValue>, bool> func) 
        {
            NeedRemoveExpression = func;
        }             


        public override bool Equals(object obj)
        {
            switch (obj)
            {
                case IValueWrapper<TValue> item:
                    return NeedRemoveExpression(item);

                default:
                    return false;
            }
        }
    }


}
