﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Tools.Collections;

namespace Tools.Collections.ConsoleTest
{
    class Test_SortedDictionarySortKeyItemKey
    {
        public void Test() 
        {
            var set = new SortedDictionarySortKeyItemKey<DateTime, Guid, Guid>(
                new SortedDictionaryComparer<DateTime, Guid>()
                { 
                    TSortKeyIsUnique = true
                }
                );

            var now = DateTime.Now;
            var id1 = Guid.NewGuid();
            var id2 = Guid.NewGuid();


            set.Add(
                new AddSortedItem<DateTime, Guid>(now, id1),
                id1
            );
            set.Add(
                new AddSortedItem<DateTime, Guid>(now, id2),
                id2
            );

            Console.WriteLine(set.Count);

            Console.WriteLine(set[new GetSortedItem<DateTime, Guid>(id1)]);
            Console.WriteLine(set[new GetSortedItem<DateTime, Guid>(id2)]);

            Console.WriteLine("end");

            set.Remove(new GetSortedItem<DateTime, Guid>(id1));
        }
    }
}
