﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Tools.Collections
{
    public abstract class BaseSortedDictionaryComparer<TSortKey, TItemKey>
        : IComparer<BaseSortedItem<TSortKey, TItemKey>>
    {
        protected readonly Func<TSortKey, TSortKey, int> SortKeyComparer;
        protected readonly Func<TItemKey, TItemKey, int> ItemKeyComparer;

        /// <summary>
        /// TSortKey is unique values only
        /// </summary>
        public bool TSortKeyIsUnique { set; get; }


        protected BaseSortedDictionaryComparer(
            Func<TSortKey, TSortKey, int> sortKeyComparer, 
            Func<TItemKey, TItemKey, int> itemKeyComparer
            ) 
        {
            SortKeyComparer = sortKeyComparer;
            ItemKeyComparer = itemKeyComparer;
        }


        public int Compare(
            BaseSortedItem<TSortKey, TItemKey> x, 
            BaseSortedItem<TSortKey, TItemKey> y
            )
        {
            if (x is GetSortedItem<TSortKey, TItemKey>)
            {
                return ItemKeyComparer(x.ItemKey, y.ItemKey);
            }
            else
            {
                var compareRes = SortKeyComparer(x.SortKey, y.SortKey);

                if (
                    compareRes != 0
                    || TSortKeyIsUnique
                    )
                {
                    return compareRes;
                }

                return ItemKeyComparer(x.ItemKey, y.ItemKey);
            }
        }
    }


    public class SortedDictionaryComparer_SortKeyItemKey<TSortKey, TItemKey>
        : BaseSortedDictionaryComparer<TSortKey, TItemKey>
    {
        public SortedDictionaryComparer_SortKeyItemKey(
            IComparer<TSortKey> sortKeyComparer,
            IComparer<TItemKey> itemKeyComparer
            )
            : base(
                  sortKeyComparer.Compare, 
                  itemKeyComparer.Compare
                  )
        {
        }

    }

    public class SortedDictionaryComparer_SortKey<TSortKey, TItemKey>
        : BaseSortedDictionaryComparer<TSortKey, TItemKey>
        where TSortKey : IComparable<TSortKey>
    {
        public SortedDictionaryComparer_SortKey(
            IComparer<TItemKey> itemKeyComparer
            )
            : base(
                  (TSortKey tk1, TSortKey tk2) => tk1.CompareTo(tk2),
                  itemKeyComparer.Compare
                  )
        {
        }

    }

    public class SortedDictionaryComparer_TItemKey<TSortKey, TItemKey>
        : BaseSortedDictionaryComparer<TSortKey, TItemKey>
        where TItemKey : IComparable<TItemKey>
    {
        public SortedDictionaryComparer_TItemKey(
            IComparer<TSortKey> sortKeyComparer
            )
            : base(
                  sortKeyComparer.Compare,
                  (TItemKey ti1, TItemKey ti2) => ti1.CompareTo(ti2)
                  )
        {
        }

    }


    public class SortedDictionaryComparer<TSortKey, TItemKey>
        : BaseSortedDictionaryComparer<TSortKey, TItemKey>
        where TItemKey : IComparable<TItemKey>
        where TSortKey : IComparable<TSortKey>
    {
        public SortedDictionaryComparer()
            : base(
                  (TSortKey tk1, TSortKey tk2) => tk1.CompareTo(tk2),
                  (TItemKey ti1, TItemKey ti2) => ti1.CompareTo(ti2)
                  )
        {
        }

    }


}
