﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Tools.Collections
{
    public abstract class BaseSortedItem<TSortKey, TItemKey>
    {
        public TSortKey SortKey { private set; get; }
        public TItemKey ItemKey { private set; get; }

        public BaseSortedItem(TSortKey sortKey)
        {
            SortKey = sortKey;
        }
        public BaseSortedItem(TItemKey itemKey)
        {
            ItemKey = itemKey;
        }

        public BaseSortedItem(TSortKey sortKey, TItemKey itemKey)
        {
            SortKey = sortKey;
            ItemKey = itemKey;
        }


        public override int GetHashCode()
        {
            return ItemKey.GetHashCode();
        }

        public override bool Equals(object obj)
        {
            if (obj == null)
            {
                return false;
            }

            var typedObj = (BaseSortedItem<TSortKey, TItemKey>)obj;
            return ItemKey.Equals(typedObj.ItemKey);
        }

        public override string ToString()
        {
            return ItemKey.ToString();
        }
    }

    /// <summary>
    /// Use for add to SortedDictionary
    /// </summary>
    /// <typeparam name="TSortKey"></typeparam>
    /// <typeparam name="TItemKey"></typeparam>
    public sealed class AddSortedItem<TSortKey, TItemKey>
        : BaseSortedItem<TSortKey, TItemKey>
    {
        public AddSortedItem(TSortKey sortKey, TItemKey itemKey)
            : base(sortKey, itemKey)
        {
        }
    }

    /// <summary>
    /// Use for get from SortedDictionary
    /// </summary>
    /// <typeparam name="TSortKey"></typeparam>
    /// <typeparam name="TItemKey"></typeparam>
    public sealed class GetSortedItem<TSortKey, TItemKey>
    : BaseSortedItem<TSortKey, TItemKey>
    {
        public GetSortedItem(TItemKey itemKey)
            : base(itemKey)
        {
        }
    }

}
