﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;
using System.Collections.Concurrent;

using Tools.Collections.Concurrent.Extensions;

namespace Tools.Collections.ConsoleTest
{
    class Test_ConcurrentDictionaryRemoveIf
    {

        public class LinkItem<T>
        {
            public int LinkCount { set; get; } = 0;
            public T Value { set; get; }
        }

        public IValueWrapper<LinkItem<TValue>> AddLink<TKey, TValue>(
            ConcurrentDictionary<TKey, IValueWrapper<LinkItem<TValue>>> dictionary, 
            TKey key, 
            TValue value
            )
        {
            return dictionary.AddOrUpdate(
                key,
                new RealItemWrapper<LinkItem<TValue>>(
                    new LinkItem<TValue>()
                    {
                        LinkCount = 1,
                        Value = value
                    }
                    ),
                (TKey tkey, IValueWrapper<LinkItem<TValue>> item) =>
                    new RealItemWrapper<LinkItem<TValue>>(
                        new LinkItem<TValue>()
                        {
                            LinkCount = item.Value.LinkCount + 1,
                            Value = item.Value.Value
                        }
                        )
                    );
        }

        public bool RemoveLink<TKey, TValue>(
            ConcurrentDictionary<TKey, IValueWrapper<LinkItem<TValue>>> dictionary,
            TKey key
            )
        {
            var result = dictionary.AddOrUpdate(
                key,
                new RealItemWrapper<LinkItem<TValue>>(
                    new LinkItem<TValue>()
                    {
                        LinkCount = 0,
                        Value = default(TValue)
                    }
                    ),
                (TKey tkey, IValueWrapper<LinkItem<TValue>> item) =>
                    new RealItemWrapper<LinkItem<TValue>>(
                        new LinkItem<TValue>()
                        {
                            LinkCount = item.Value.LinkCount - 1,
                            Value = item.Value.Value
                        }
                        )
                    );

            //Remove item if link count = 0

            //if (result.Value.LinkCount != 0)
            //{
            //    return false;
            //}

            return dictionary.RemoveIf(
                key,
                (IValueWrapper<LinkItem<TValue>> item) => item.Value.LinkCount == 0
                );
        }



        public void TestMethod()
        {
            ConcurrentDictionary<string, IValueWrapper<LinkItem<string>>>
                dictionary = new ConcurrentDictionary<string, IValueWrapper<LinkItem<string>>>();

            //Add first link to key
            AddLink(dictionary, "key", "value");
            //Add second link to key
            AddLink(dictionary, "key", "value");

            //Remove first link to key
            var removeResult1 = RemoveLink(dictionary, "key");
            //Remove first link to key
            var removeResult2 = RemoveLink(dictionary, "key");

            Console.ReadLine();
        }

    }
}
