﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Collections.Concurrent;

namespace Tools.Collections.Concurrent.Extensions
{

    public static class ConcurrentDictionaryExtensions 
    {
        /// <typeparam name="TKey">Item Key</typeparam>
        /// <typeparam name="TData">Data Type</typeparam>
        /// <param name="key">key</param>
        /// <param name="removeExpression">Remove if true</param>
        public static void RemoveIf<TKey, TData>(
            this ConcurrentDictionary<TKey, IValueWrapper<TData>> dictionary,
            TKey key,
            Func<IValueWrapper<TData>, bool> removeExpression
            )
        {
            var collection = (ICollection<KeyValuePair<TKey, IValueWrapper<TData>>>) dictionary;

            collection
                .Remove(
                    new KeyValuePair<TKey, IValueWrapper<TData>>(
                        key, 
                        new RemoveExpressionItem<TData>(removeExpression)
                        )
                    );
        }

        /// <typeparam name="TKey">Item Key</typeparam>
        /// <typeparam name="TData">Data Type</typeparam>
        /// <param name="key">key</param>
        /// <param name="removeExpression">Remove if true</param>
        public static void RemoveIf<TKey, TData>(
            this ICollection<KeyValuePair<TKey, IValueWrapper<TData>>> collection,
            TKey key,
            Func<IValueWrapper<TData>, bool> removeExpression
            )
        {
            collection
                .Remove(
                    new KeyValuePair<TKey, IValueWrapper<TData>>(
                        key,
                        new RemoveExpressionItem<TData>(removeExpression)
                        )
                    );
        }

    }

}
