﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

using Tools.Collections.Concurrent;

namespace ManagetLinkCollection.ConsoleTest
{
    class Test_LinkItemDictionary
    {

        public LinkItemDictionary<int, int> TestMethod1()
        {
            LinkItemDictionary<int, int> storage
                = new LinkItemDictionary<int, int>();

            storage.AddLink(1, (int k) => 1);

            Task.Run(() =>
            {
                storage.AddLink(1,
                    (int k) =>
                    {
                        Write("t1", "add start");
                        Thread.Sleep(5000);

                        Write("t1", "add stop");
                        return -1;
                    },
                (LinkItem<int, int> old_v) =>
                {
                    Write("t1", "update start");
                    Thread.Sleep(5000);

                    Write("t1", "update stop");
                    return -1;
                });
            });

            Thread.Sleep(200);

            Task.Run(() =>
            {
                storage.AddLink(1,
                    (int k) =>
                    {
                        Write("t2", "add start");
                        //Thread.Sleep(5000);

                        Write("t2", "add stop");
                        return -2;
                    },
                (LinkItem<int, int> old_v) =>
                {
                    Write("t2", "update start");
                    Write("t2", "update stop");

                    //d.TryRemove(k, out int v);
                    //throw new OperationCanceledException();

                    return -2;
                });
            });

            Console.ReadLine();
            return storage;
        }

        public void TestMethod2()
        {
            LinkItemDictionary<int, int> storage
                = new LinkItemDictionary<int, int>();

            storage.AddLink(1, (int k) => 1);

            Task.Run(() =>
            {
                storage.AddLink(1,
                    (int k) =>
                    {
                        Write("t1", "add start");
                        Thread.Sleep(5000);

                        Write("t1", "add stop");
                        return -1;
                    },
                (LinkItem<int, int> old_v) =>
                {
                    Write("t1", "update start");
                    Thread.Sleep(5000);

                    Write("t1", "update stop");
                    return -1;
                });
            });

            Thread.Sleep(200);

            Task.Run(() =>
            {
                storage.RemoveLink(1,
                (LinkItem<int, int> old_v) =>
                {
                    Write("t2", "update start");

                    Write("t2", "update stop");
                    return old_v.Value;
                }
                    );
            });

            Console.ReadLine();
        }


        static void Write(string thread, string text)
        {
            Console.WriteLine($"{DateTime.Now.ToString("HH:mm:ss.fff")}|{thread}|{text}");
        }

    }
}
