﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


namespace Tools.Collections.Concurrent
{
    /// <summary>
    /// Immutable item with link counter
    /// </summary>
    public sealed class LinkItem<TKey, TData>
    {
        /// <summary>
        /// ItemVersionControl
        /// </summary>
        //private DateTime TimeStamp { set; get; } = DateTime.Now;
        private Guid Stamp { set; get; } = Guid.NewGuid();


        public TKey Key { private set; get; }
        public int LinkCount { private set; get; }
        public TData Value { private set; get; }


        internal LinkItem(TKey key, int linkCount)
        {
            Key = key;
            LinkCount = linkCount;
        }
        internal LinkItem(TKey key, int linkCount, TData data)
        {
            Key = key;
            LinkCount = linkCount;
            Value = data;
        }


        public override int GetHashCode()
        {
            return Key.GetHashCode();
        }

        public override bool Equals(object obj)
        {
            switch (obj)
            {
                case null:
                    return false;

                case LinkItem<TKey, TData> item:
                    return
                        Stamp.Equals(item.Stamp);
                        //&& Value.Equals(item.Value)
                        //&& LinkCount.Equals(item.LinkCount);

                default:
                    return false;
            }
        }
    }

}
