﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ManagetLinkCollection.LinkStorage.Entities
{
    public interface ILinkItem<TKey, TData>
    {
        /// <summary>
        /// Значение ключа
        /// </summary>
        TKey Key { get; }

        /// <summary>
        /// Кол-во объектов, ссылающихся на данные
        /// </summary>
        int LinkCount { get; }

        /// <summary>
        /// Данные
        /// </summary>
        TData Data { get; }
    }

    internal class RealLinkItem<TKey, TData> 
        : ILinkItem<TKey, TData>
    {
        /// <summary>
        /// Используется как штамп, для понимания изменилась ли исходная сущность после начала операции.
        /// </summary>
        //private DateTime TimeStamp { set; get; } = DateTime.Now;
        private Guid Stamp { set; get; } = Guid.NewGuid();


        public TKey Key { private set; get; }
        public int LinkCount { private set; get; }
        public TData Data { private set; get; }


        public RealLinkItem(TKey key, int linkCount)
        {
            Key = key;
            LinkCount = linkCount;
        }
        public RealLinkItem(TKey key,  int linkCount, TData data)
        {
            Key = key;
            LinkCount = linkCount;
            Data = data;
        }

        public override bool Equals(object obj)
        {
            switch (obj)
            {
                case null:
                    return false;

                case RealLinkItem<TKey, TData> item:
                    return
                        Key.Equals(item.Key)
                        //TimeStamp.Equals(item.TimeStamp)
                        && Stamp.Equals(item.Stamp)
                        && LinkCount.Equals(item.LinkCount);
                case RemoveLinkItem<TKey, TData> item:
                    return
                        LinkCount <= 0;

                default:
                    return false;
            }
        }
    }

    /// <summary>
    /// Специальный объект для удаления
    /// эквивалентен любой записи со значением ссылок <= 0
    /// </summary>
    internal class RemoveLinkItem<TKey, TData> : ILinkItem<TKey, TData>
    {
        public TKey Key => throw new NotImplementedException();
        public int LinkCount => throw new NotImplementedException();
        public TData Data => throw new NotImplementedException();

        public override bool Equals(object obj)
        {
            switch (obj)
            {
                case ILinkItem<TKey, TData> item:
                    return
                        item.LinkCount <= 0;
                default:
                    return false;
            }
        }
    }

}
