﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Tools.CancellationTokenAsync;

namespace Tools.Collections.Concurrent.AsyncBuffer.PriorityWrapper
{
    public interface IConcurrentBufferPriorityWrapper<T, TPriority>
        : IConcurrentBuffer<T>
    {
        /// <summary>
        /// Принудительно добавить в хранилище.
        /// Не проверяет значение RecommendedMaxSize
        /// </summary>
        /// <param name="dateEntity"></param>
        void AddForce(T dateEntity, TPriority priority);

        /// <summary>
        /// Попытка добавить запись в хранилище.
        /// Запись не будет добавлена, если хранилище заполнено (RecommendedMaxSize).
        /// При выполнении хранилище не блокируется, и значение Size может превысить RecommendedMaxSize. 
        /// </summary>
        bool TryAdd(T dataEntity, TPriority priority);

    }

}
