﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Tools.CancellationTokenAsync;

namespace Tools.Collections.Concurrent.AsyncBuffer.PriorityWrapper
{
    public class ConcurrentBufferPriorityWrapper<T, TPriority>
        : ConcurrentBuffer<T>,
        IConcurrentBufferPriorityWrapper<T, TPriority>
    {
        private readonly IConcurrentStorePriorityWrapper<T, TPriority> _PriorityStorage;

        public ConcurrentBufferPriorityWrapper(
            int recommendedMaxSize,
            IConcurrentStorePriorityWrapper<T, TPriority> storage
            )
            : base(recommendedMaxSize, storage)
        {
            _PriorityStorage = storage;
        }

        public void AddForce(T dateEntity, TPriority priority) 
        {
            _PriorityStorage.Add(dateEntity, priority);
        }

        public bool TryAdd(T dataEntity, TPriority priority) 
        {
            if (Size >= RecommendedMaxSize)
            {
                return false;
            }

            AddForce(dataEntity, priority);
            return true;
        }

    }

}
