﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;
using System.Collections.Concurrent;
using System.Collections.Specialized;
using System.Collections.ObjectModel;

using Tools.CancellationTokenAsync;

namespace Tools.Collections.Concurrent.AsyncBuffer
{
    public interface IConcurrentBuffer<T>
    {
        /// <summary>
        /// Рекомендуемый максимальный размер.
        /// Само хранилище не контролирует размер
        /// </summary>
        int RecommendedMaxSize { get; }

        /// <summary>
        /// Текущий размер коллекции
        /// </summary>
        int Size { get; }

        //IConcurrentStore<T> Storage { get; }

        /// <summary>
        /// Запрашивает группу данных из хранилища для обработки. n - кол-во данных в хранилище.
        /// Если n = 0, то ожидает поступления данных.
        /// Если n <= maxBatchSize, то возвращает n записей.
        /// Если n > maxBatchSize, то возвращает maxBatchSize записей.
        /// </summary>
        /// <param name="maxBatchSize">Максимальный размер группы</param>
        /// <param name="cancellation">Токен, прерывает ожидание новых данных в случае n = 0</param>
        /// <returns></returns>
        Task<T[]> ConsumeBatchOrWaitAsync(
            int maxBatchSize,
            CancellationToken cancellation = default,
            bool configureAwait = false,
            bool throwOperationCanceledException = false
            );

        /// <summary>
        /// Извлекает один элемент или ожидает, пока он не появиться или до отмены.
        /// </summary>
        Task<T> ConsumeOrWaitAsync(
            CancellationToken cancellation = default,
            bool configureAwait = false,
            bool throwOperationCanceledException = false
            );


        /// <summary>
        /// Принудительно добавить в хранилище.
        /// Не проверяет значение RecommendedMaxSize
        /// </summary>
        /// <param name="dateEntity"></param>
        void AddForce(T dateEntity);

        /// <summary>
        /// Попытка добавить запись в хранилище.
        /// Запись не будет добавлена, если хранилище заполнено (RecommendedMaxSize).
        /// При выполнении хранилище не блокируется и значение Size может превысить RecommendedMaxSize. 
        /// </summary>
        bool TryAdd(T dataEntity);

    }

}
