﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Threading.Tasks;
using System.Collections.Generic;
using System.Linq;

using Tools.Collections.Concurrent.AsyncBuffer;
using Tools.Collections.Concurrent.AsyncBuffer.Store;
using Tools.Collections.Concurrent.AsyncBuffer.PriorityWrapper;

using Tools.Collections.Concurrent.AsyncBuffer.UnitTest.Fake;

namespace Tools.Collections.Concurrent.AsyncBuffer.UnitTest
{
    [TestClass]
    public class PriorityBufferTest
    {
        [TestMethod]
        public void TestConcurrentBuffer()
        {
            IConcurrentStore<string> store
                = new QueueStore<string>();
            IConcurrentBuffer<string> dataStor
                = new ConcurrentBuffer<string>(100, store);

            var producerTask = Task.Run(
                () =>
                {
                    for (int i = 0; i < Settings.Count; i++)
                    {
                        dataStor.AddForce(i.ToString());
                    }
                }
                );

            var consumerTask = Task.Run(
                async () =>
                {
                    for (int i = 0; i < Settings.Count; i++)
                    {
                        await dataStor.ConsumeOrWaitAsync()
                            .ConfigureAwait(false);
                    }
                }
                );

            Task.WaitAll(
                producerTask,
                consumerTask
                );

            if (dataStor.Size != 0)
            {
                throw new Exception();
            }
        }

        [TestMethod]
        public void TestConcurrentBufferPriorityWrapper2()
        {
            EnumTestPrioriry[] priorityValues
                = (EnumTestPrioriry[])Enum.GetValues(typeof(EnumTestPrioriry));

            if (Settings.Count % priorityValues.Length != 0)
            {
                throw new Exception("Count % priorityValues.Length != 0");
            }
            var cnt = Settings.Count / priorityValues.Length;

            // Key - приоритет
            // Value - соответсующее приоритету хранилище
            var concurrentStores
                = new SortedDictionary<EnumTestPrioriry, IConcurrentStore<EnumTestPrioriry>>(
                    priorityValues
                        .ToDictionary(
                            e => e,
                            e => new QueueStore<EnumTestPrioriry>() as IConcurrentStore<EnumTestPrioriry>
                            ),
                    new PriorityComparer()
                    );

            var priorityStore
                = new ConcurrentStorePriorityWrapper<EnumTestPrioriry, EnumTestPrioriry>(concurrentStores);

            var priorityBuffer
                = new ConcurrentBufferPriorityWrapper<EnumTestPrioriry, EnumTestPrioriry>(Settings.Count, priorityStore);


            foreach (var elem in priorityValues)
            {
                for (int i = 0; i < cnt; i++)
                {
                    priorityBuffer.AddForce(elem, elem);
                }
            }

            foreach (var elem in priorityValues)
            {
                if (concurrentStores[elem].Size != cnt)
                {
                    throw new Exception("Ошибка заполнения хранилища с приоритетами");
                }
            }

            //Проверяем, что порядок извлечения элементов из буфера идет по убыванию за счет PriorityComparer
            foreach (var elem in priorityValues.OrderByDescending(e => e))
            {
                for (int i = 0; i < cnt; i++)
                {
                    var consumeResult = priorityBuffer
                        .ConsumeOrWaitAsync()
                        .GetAwaiter()
                        .GetResult();

                    if (consumeResult != elem)
                    {
                        throw new Exception($"Неверный порядок приоритета {consumeResult}");
                    }
                }
            }

            if (
                priorityStore.Size != 0
                || priorityBuffer.Size != 0
                )
            {
                throw new Exception();
            }
        }

    }
}
