﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Collections;

namespace Tools.Collections
{

    /// <summary>
    /// Sort by TSortKey, Get item by TItemKey.
    /// 
    /// To add item use KeyEntity: Tools.Collections.SortedDictionarySortKeyItemKey.AddSortedItem.
    /// To get item use KeyEntity: Tools.Collections.SortedDictionarySortKeyItemKey.GetSortedItem.
    /// </summary>
    /// <typeparam name="TSortKey">Key for sorting</typeparam>
    /// <typeparam name="TItemKey">Key for item</typeparam>
    /// <typeparam name="TValue">Value</typeparam>
    public class SortedDictionarySortKeyItemKey<TSortKey, TItemKey, TValue>
        : SortedDictionary<BaseSortedItem<TSortKey, TItemKey>, TValue>
    {
        private BaseSortedDictionaryComparer<TSortKey, TItemKey> SpecialComparer => 
            (BaseSortedDictionaryComparer<TSortKey, TItemKey>)Comparer;

        /// <summary>
        /// TSortKey is unique values only
        /// </summary>
        public bool TSortKeyIsUnique 
        {
            set => SpecialComparer.TSortKeyIsUnique = value;
            get => SpecialComparer.TSortKeyIsUnique; 
        }

        public SortedDictionarySortKeyItemKey(
            BaseSortedDictionaryComparer<TSortKey, TItemKey> comparer
            ) : base(
                comparer
                )
        {            
        }

        public SortedDictionarySortKeyItemKey(
            IDictionary<BaseSortedItem<TSortKey, TItemKey>, TValue> dictionary,
             BaseSortedDictionaryComparer<TSortKey, TItemKey> comparer
            ) : base(
                dictionary,
                comparer
                )
        {
        }
    }
}
