﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Threading.Tasks;
using System.Collections.Generic;
using System.Linq;

using Tools.Collections.Concurrent.AsyncBuffer;
using Tools.Collections.Concurrent.AsyncBuffer.Store;
using Tools.Collections.Concurrent.AsyncBuffer.PriorityWrapper;

namespace Tools.Collections.Concurrent.AsyncBuffer.UnitTest
{
    [TestClass]
    public class BufferTest
    {
        [TestMethod]
        public void TestConcurrentBuffer()
        {
            IConcurrentStore<string> store
                = new QueueStore<string>();
            IConcurrentBuffer<string> dataStor
                = new ConcurrentBuffer<string>(100, store);

            var producerTask = Task.Run(
                () =>
                {
                    for (int i = 0; i < Settings.Count; i++)
                    {
                        dataStor.AddForce(i.ToString());
                    }
                }
                );

            var consumerTask = Task.Run(
                async () =>
                {
                    for (int i = 0; i < Settings.Count; i++)
                    {
                        await dataStor.ConsumeOrWaitAsync()
                            .ConfigureAwait(false);
                    }
                }
                );

            Task.WaitAll(
                producerTask,
                consumerTask
                );

            if (dataStor.Size != 0)
            {
                throw new Exception();
            }
        }

    }
}
