﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Drawing.Design;
using System.ComponentModel;

namespace WinForm_And_Data.Data.DataEntity
{

    //Аттрибут для отобрадения свойсвт этого объекта в PropertyView, 
    //когда он является частью другого обеъкта
    [TypeConverter(typeof(ExpandableObjectConverter))]
    public class Entity
    {
        public enum EnumType
        {
            type1,
            type2,
            type3
        }

        public int Id { set; get; }
        public string Name { set; get; }
        public int Age { set; get; }

        //Атрибут для расширенного текстового редактора PropertyGrid
        [Editor("System.ComponentModel.Design.MultilineStringEditor, System.Design, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a",
                "System.Drawing.Design.UITypeEditor, System.Drawing, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
        public string Description { set; get; }

        public EnumType type { set; get; }
      

        private static int ID_Count = -1;
        public static Entity GetNewEntity()
        {
            ID_Count++;
            return new Entity()
            {
                Id = ID_Count,
                Name = "Name " + ID_Count,
                Age = 20 + ID_Count,
                Description = "Description" + ID_Count,
                type = EnumType.type1
            };
        }

        public override string ToString()
        {
            return Name;
        }

    }
}
