﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Model.ViewModel.Files
{
    public class PathItem
    {
        public int ID { set; get; }
        public string Name { set; get; }

        public static PathItem GetRoot() => new PathItem()
        {
            ID = -1,
            Name = "Root"
        };

        public static List<PathItem> GetDefault() => new List<PathItem>()
        {
            GetRoot()
        };
    }

    public class ExplorerItem
    {
        public int ID { set; get; }
        public string Name { set; get; }
        public string Type { set; get; }
        public decimal Size { set; get; }
    }

    public class UploadBlob
    {
        public int ID { set; get; }
        public string chunk { set; get; }

        public byte[] ToByte()
        {
            var base64 = chunk.Substring(@"data:application/octet-stream;base64,".Length);
            return Convert.FromBase64String(base64);
        }
    }

}
