﻿
import React from 'react';
import { Link } from 'react-router-dom';
import { Button, Form } from 'react-bootstrap'

import BaseControl from '../../BaseControl.jsx'


export default class FileExplorerRow extends BaseControl {

    constructor(props) {
        super(props, "FileExplorerRow");

        this.state = {
            Data: this.props.data,
            ShoSelectColumn: this.props.ShoSelectColumn
        };
    }

    componentWillReceiveProps(nextProps) {
        this.props = nextProps;

        if (this.refs.Select != undefined)
            this.refs.Select.checked = false;

        this.setState({
            Data: this.props.data,
            ShoSelectColumn: this.props.ShoSelectColumn
        });

        //Log("FileExplorerRow " + this.props.ID, "GetDataID: " + this.GetDataID());
    }

    GetDirectory() {
        return this.GlobalState[this.props.CurrentDirectoryName];
    }

    GetData() {
        return this.state.Data;
    }

    GetDataID() {
        return this.state.Data.ID;
    }
    IsCheked() {
        if (this.refs.Select == undefined)
            return false;

        return this.refs.Select.checked;
    }


    OnDirectoryClick() {
        this.GetDirectory().ID = this.GetDataID();
        this.EventRegister.EventAction(this.GetDirectory().ChangeEvent);
    }

    render() {
        let state = this.state;
        let elem = state.Data;

        return (
            <tr>
                <td>{elem.ID}</td>
                {state.ShoSelectColumn
                    ?
                    <td>
                        <Form.Check ref="Select"/>                       
                    </td>
                    : null
                }


                {(elem.Type === "RootDirectory" || elem.Type === "Directory")
                    ?
                    <td>
                        <Link to={`/?ID=${elem.ID}`}>
                            <Button id={elem.ID} onClick={this.OnDirectoryClick} variant="light">
                                {elem.Name}
                            </Button>
                        </Link>
                    </td>
                    : <td>{elem.Name}</td>
                }
                <td>{elem.Type}</td>

                {elem.Size !== -1
                    ? <td>{elem.Size}</td>
                    : <td></td>
                }
            </tr>
        );
    }
}