﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Optimization;
using System.Web.Routing;

using System.Threading.Tasks;

using Web.BackgroundWorkers;

using BLL.Services;
using BLL.Services.FS;

using Model.Tools;

namespace Web
{
    public class MvcApplication : System.Web.HttpApplication
    {
        protected void Application_Start()
        {
            AreaRegistration.RegisterAllAreas();
            FilterConfig.RegisterGlobalFilters(GlobalFilters.Filters);
            RouteConfig.RegisterRoutes(RouteTable.Routes);
            //BundleConfig.RegisterBundles(BundleTable.Bundles);

            //Для обработки POST json запросов
            ValueProviderFactories.Factories.Add(new JsonValueProviderFactory());


            var Config = ConfigTools.Get();

            //Расположение конфигурации
            Config.ConfigDirectory = Server.MapPath("~/");
            Config.Import();


            //Очистить базу данных
            //Проинициализирвоать базу 
            using (var UOW = Model.UnitsOfWork.UOW.InitRepo(true))
            {
                //Прочитать корневые папки
                new ConfigurationServices(UOW, Config).ReadConfiguration();
                //Просканировать все папки
                Task.WaitAll(new ScanServices(UOW).ScanAllDirs());

                // запуск выполнения работы
                //Удаление мертвых загрузок
                GarbageUploadsScheduler.Start();
                //Обновление файла конфигурации
                ConfigScheduler.Start();

                var u = UOW.Repo_User.All.AsEnumerable();
                foreach (var elem in u)
                {

                }
                var q = u.AsQueryable();
            }
        }
    }
}
