﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using BLL.Services.System;
using BLL.Services.Mapper;
using Model.ViewModel.Edit;
using Model.ViewModel;

using Web.Models.Base;

namespace Web.Controllers.API
{

    public class AuthResult : BaseApiResult
    {
        public AuthResult(
            Base.BaseController controller, 
            bool Successe, 
            string ResMsg, 
            string Token, 
            UserInfoModel userInfoModel) 

            : base(controller, Successe, ResMsg)
        {
            this.Token = Token;
            this.User = userInfoModel;
        }

        public string Token { set; get; }

        public UserInfoModel User { set; get; }

        //public string UserName { set; get; }
    }


    public class AuthController : Base.BaseApiController
    {
        readonly UserMapper UserMapper;


        public AuthController()
        {
            UserMapper = new UserMapper(UOW, permissionServices);
        }

        /// <summary>
        /// Должен выдавать токен авторизации
        /// </summary>
        /// <param name="Login"></param>
        /// <param name="Password"></param>
        /// <returns></returns>
        /// 
        [HttpPost]
        public JsonResult Auth(string Login, string Password)
        {
            var user = UOW.Repo_User.All_NoTrack.
                FirstOrDefault(e => e.Login == Login && e.Password == Password
                && e.IsActive);

            if (user != null)
            {
                return new AuthResult(
                    this,
                    true,
                    "",
                    TokenServices.CreateTocken(user.ID, new TimeSpan(1, 0, 0)),
                    UserMapper.GetInfo_User(user)
                    ).ToJson;
            }
            else
            {
                return new AuthResult(
                    this,
                    false,
                    "Пользователь не найден или заблокирован/Время авторизации истекло",
                    "", null).ToJson;
            }
        }


        [HttpPost]
        public JsonResult UserInfo()
        {
            if (CurrentUser != null)
            {
                return new AuthResult(
                    this,
                    true,
                    "",
                    TokenServices.CreateTocken(CurrentUser.ID, new TimeSpan(1, 0, 0)),
                    UserMapper.GetInfo_User(CurrentUser)
                    ).ToJson;
            }
            else
            {
                return new AuthResult(
                    this,
                    false,
                    "Пользователь не найден или заблокирован",
                    "",
                    null).ToJson;
            }
        }

        [HttpPost]
        public JsonResult SetUser(UserInfoModel model)
        {
            if (CurrentUser == null)
            {
                return new BaseApiResult(
                    this,
                    false,
                    "Пользователь не найден или заблокирован"
                    ).ToJson;
            }

            string ResMsg = "";
            if (!string.IsNullOrEmpty(model.Password))
            {
                CurrentUser.Password = model.Password;
                UOW.Repo_User.Update(CurrentUser);

                ResMsg = CurrentUser.Login + " Password update";
            }

            return new BaseApiResult(this, true, ResMsg).ToJson;
        }

        public class UserInfoModel
        {
            public string Login { set; get; }
            public string Password { set; get; }
            public string IsAdmin { set; get; }

            public List<InfoRootDirModel> RootDirs { set; get; }
        }


    }
}