﻿
import React from 'react';
import { Nav } from 'react-bootstrap'

import Log from '../../Tools/LogTools'

import AuthServices from '../../Services/AuthServices'

import BaseControl from '../BaseControl.jsx'
import MenuControl from '../Controls/MenuControl.jsx'
import UserListControl from '../Controls/Admin/UserListControl.jsx'
import GroupListControl from '../Controls/Admin/GroupListControl.jsx'


export default class AdministratorPage extends BaseControl {

    constructor(props) {
        super(props, "AdministratorPage");

        this.state = { ActiveWindows: 0 };
        this.authServices = new AuthServices();
    }

    OnUsersClick() {
        this.setState({ ActiveWindows: 0 });
    }
    OnGroupsClick() {
        this.setState({ ActiveWindows: 1 });
    }


    render() {
        return (
            <div>
                {this.authServices.IsAuth()
                    ?
                    <div>
                        <Nav variant="tabs">
                            <Nav.Item>
                                <Nav.Link onClick={this.OnUsersClick}>Users</Nav.Link>
                            </Nav.Item>
                            <Nav.Item>
                                <Nav.Link onClick={this.OnGroupsClick}> Groups</Nav.Link>
                            </Nav.Item>
                        </Nav>

                        {this.state.ActiveWindows == 0
                            ?
                            <div>
                                <UserListControl ref="UserListControl" />
                            </div>
                            :
                            <div>
                                <GroupListControl ref="GroupListControl" />
                            </div>
                        }
                    </div>
                    : <p>Вы не авторизованы</p>
                }

            </div>
        );
    }
}

