﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using Model.Entities.Users;
using Web.Models.Base;

namespace Web.Controllers
{

    public class AuthResult
    {
        public bool Successe { set; get; }
        public string ResMsg { set; get; }

        public string Token { set; get; }
        public string UserName { set; get; }
    }


    public class UserController : BaseApiController
    {

        /// <summary>
        /// Должен выдавать токен авторизации
        /// </summary>
        /// <param name="Login"></param>
        /// <param name="Password"></param>
        /// <returns></returns>
        /// 
        [HttpPost]
        public JsonResult Auth(string Login, string Password)
        {
            var user = UOW.Repo_User.All_NoTrack.
                FirstOrDefault(e => e.Login == Login && e.Password == Password
                && e.IsActive);

            if (user != null)
            {
                return Json(new AuthResult()
                {
                    Successe = true,

                    Token = user.ID.ToString(),
                    UserName = user.Login
                }, JsonRequestBehavior.AllowGet);
            }
            else
            {
                return Json(new AuthResult()
                {
                    Successe = false,
                    ResMsg = "Пользователь не найден или заблокирован",

                    Token = ""
                }, JsonRequestBehavior.AllowGet);
            }
        }



        [HttpPost]
        public JsonResult UserInfo()
        {
            if (CurrentUser != null)
            {
                return Json(new AuthResult()
                {
                    Successe = true,

                    Token = CurrentUser.ID.ToString(),
                    UserName = CurrentUser.Login
                }, JsonRequestBehavior.AllowGet);
            }
            else
            {
                return Json(new AuthResult()
                {
                    Successe = false,
                    ResMsg = "Пользователь не найден или заблокирован",

                    Token = ""
                }, JsonRequestBehavior.AllowGet);
            }
        }

        [HttpPost]
        public JsonResult CreateUser(string Login, string Password)
        {
            UOW.Repo_User.Create(new User()
            {
                Login = Login,
                Password = Password,
                IsActive = true,
                Groups = new List<Group>()
                {
                    UOW.Repo_Group.GetDefaultGroup(EnumDefaultGroups.Пользователи)
                }
            });

            return Json(true, JsonRequestBehavior.AllowGet);
        }


        [HttpPost]
        public JsonResult UserList()
        {
            UserListMode json;

            if (CurrentUser.IsAdmin)
            {
                var data = UOW.Repo_User.All_NoTrack_List;
                data.ForEach(e => e.Password = "");

                json = new UserListMode(true)
                {
                    Users = data
                };
                
            }
            else
            {
                json = new UserListMode(false)
                {
                    PermissionError = true,
                    ResMessage = "Need admin"                    
                };
            }

            return Json(json);
        }

        [HttpPost]
        public JsonResult UserList(List<User> users)
        {

            return Json(true);
        }

        public class UserListMode : BaseApiResult
        {
            public UserListMode(bool Successe) : base(Successe, "", "UserList") { }

            public List<User> Users;
        }


    }
}