﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using Model.Entities.Base;
using Model.Entities.Files.FS_Entities;
using Model.Entities.Users;
using Model.UnitsOfWork;
using BLL.Services;

using Model.ViewModel.Files;

namespace Web.Controllers
{
    class UploadInfo
    {
        public bool State { set; get; }
        public string Msg { set; get; }

        public int ID { set; get; }
    }


    public class UploadFilesController : BaseApiController
    {

        [HttpPost]
        public JsonResult StartUpload(int ParentID, string Name, long size)
        {
            int ID;

            try
            {
                var parent = UOW.Repo_SDirectory.All.FirstOrDefault(e => e.ID == ParentID);
                var proj = uploadServices.StartUpload(parent, Name, size, CurrentUser);

                ID = proj.ID;
            }
            catch (Exception ex)
            {
                return Json(new UploadInfo()
                {
                    State = false,
                    Msg = ex.FullMessage()
                });
            }

            return Json(new UploadInfo()
            {
                State = true,
                ID = ID
            });
        }



        [HttpPost]
        public JsonResult UploadBlob(UploadBlob model)
        {
            try
            {
                var prog = UOW.Repo_SFileUpload.All.
                    FirstOrDefault(e => e.ID == model.ID);

                uploadServices.UploadChunk(prog, model.ToByte());
            }
            catch (Exception ex)
            {
                return Json(new UploadInfo()
                {
                    State = false,
                    Msg = ex.FullMessage()
                });
            }

            return Json(new UploadInfo()
            {
                State = true
            });
        }

        [HttpPost]
        public JsonResult Cansel(int ID)
        {
            var prog = UOW.Repo_SFileUpload.All.
                FirstOrDefault(e => e.ID == ID);

            uploadServices.Cansel(prog);

            return Json(true);
        }


    }
}