﻿
class UserControl extends React.Component {

    constructor(props) {
        super(props);
        console.log('UserControl start');

        this.state = { UserName: "", AuthResult: "" };
        this.userServices = new UserServices();

        this.AuthClick = this.AuthClick.bind(this);
        this.LogoutClick = this.LogoutClick.bind(this);

        if (this.userServices.IsAuth())
            this.userServices.GetUserInfoAsync().then(function (response) {
                response.json().then(function (data) {

                    if (data.Successe) {
                        this.userServices.SetTocken(data.Token);
                        this.setState({ UserName: data.UserName, AuthResult: "" });

                        this.props.ParentComponent.OnAuthChange();
                    }
                    else {
                        this.userServices.SetTocken("");
                        this.setState({ UserName: "", AuthResult: data.ResMsg });
                    }

                }.bind(this));
            }.bind(this));
    }

    //Кнопка входа
    AuthClick() {
        let login = this.refs.Login.value;
        let password = this.refs.Password.value;

        this.userServices.AuthAsync(login, password)
            .then(function (response) {
                response.json().then(function (data) {

                    if (data.Successe) {
                        this.userServices.SetTocken(data.Token);
                        this.setState({ UserName: data.UserName, AuthResult: "" });

                        this.props.ParentComponent.OnAuthChange();
                    }
                    else {
                        this.userServices.SetTocken("");
                        this.setState({ UserName: "", AuthResult: data.ResMsg });
                    }

                }.bind(this));
            }.bind(this));
    }

    //Кнопка выхода
    LogoutClick() {
        this.userServices.SetTocken("");
        this.setState({ UserName: "", AuthResult: "" });

        this.props.ParentComponent.OnAuthChange();
    }


    render() {
        let state = this.state;

        return (
            <div>
                {this.userServices.IsAuth()
                    ?
                    <div>
                        <p>Вы авторизованы. Пользователь: {state.UserName}.</p>
                        <button onClick={this.LogoutClick}>Logout</button>
                    </div>
                    :
                    <div>
                        <p>Вы не авторизованы {state.UserName}.  Вход:</p>
                        {state.AuthResult != "" ? <p>{state.AuthResult}</p> : ""}

                        {/*<Form.Label>Email address</Form.Label>*/}
                        <Form.Control ref="Login" type="text" placeholder="Enter login" />
                        <Form.Text className="text-muted">
                            We'll never share your login with anyone else.
                        </Form.Text>
                        <br />
                        {/*<Form.Label>Password</Form.Label>*/}
                        <Form.Control ref="Password" type="password" placeholder="Password" />
                        <br />
                        <button onClick={this.AuthClick}>Auth</button>
                    </div>
                }
            </div>
        );
    }
}
