﻿
class FileExplorerServices {
    constructor() {

        this.URL_DirectoryItems = "/Explorer/GetDirectoryItems?ID=";
        this.URL_ScanDirectory = "/Explorer/ScanDirectory?ID=";

        this.URL_Delete = "/Explorer/DeleteFile";
        this.URL_Move = "/Explorer/MoveElement";
        this.URL_Download = "/Explorer/GetFile?ID=";
        this.URL_CreateDirectory = "/Explorer/CreateDirectory?";

    }


    async DirectoryGetItemsAsync(ID) {
        let url = this.URL_DirectoryItems + ID;

        return fetch(
            url,
            {
                credentials: 'include'
            })
    }

    async ScanDirectoryAsync(ID) {
        let url = this.URL_ScanDirectory + ID;

        return fetch(url,
            {
                credentials: 'include'
            }
        );
    }

    async DeleteAsync(ID) {

        return fetch(
            this.URL_Delete,
            {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                credentials: 'include',
                body: JSON.stringify({
                    ID: ID
                })
            }
        )
    }

    async MoveAsync(elemID, directoryID) {
        return fetch(
            this.URL_Move,
            {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                credentials: 'include',
                body: JSON.stringify({
                    ID: elemID,
                    NewParent: directoryID
                })
            }
        )
    }


    OpenDownload(ID) {
        let url = this.URL_Download + ID;

        window.open(url, '_blank');
    }

    async CreateDirectoryAsync(dirname, id) {
        return fetch(this.URL_CreateDirectory,
            {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                credentials: 'include',
                body: JSON.stringify({
                    ParentID: id,
                    Name: dirname
                })
            }
        );
    }

}