﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Optimization;
using System.Web.Routing;

using System.Threading.Tasks;
using System.Web.Http;

using Web.BackgroundWorkers;

using Model.UnitsOfWork;
using BLL.Services;


namespace Web
{
    public class MvcApplication : System.Web.HttpApplication
    {
        protected void Application_Start()
        {
            AreaRegistration.RegisterAllAreas();
            FilterConfig.RegisterGlobalFilters(GlobalFilters.Filters);
            RouteConfig.RegisterRoutes(RouteTable.Routes);
            BundleConfig.RegisterBundles(BundleTable.Bundles);

            //Для обработки POST json запросов
            ValueProviderFactories.Factories.Add(new JsonValueProviderFactory());

            //Очистить базу данных
            new Context(true);
            var UOW = new UOW();
            //Прочитать корневые папки
            new ConfigurationServices(UOW).ReadConfiguration();
            //Просканировать все папки
            Task.WaitAll(new ScanServices(UOW).ScanAllDirs());


            // запуск выполнения работы
            GarbageUploadsScheduler.Start();
        }
    }
}
