﻿
class FileExplorerControl extends React.Component {

    constructor(props) {
        super(props);
        console.log('FileExplorer start');

        this.state = { data: {}, ShoSelect: this.props.ShoSelect };
        this.ChildRows = [];
        this.fileExplorerServices = new FileExplorerServices();

        //#region Binding

        //this.GetID = this.props.Pa.GetID;
        //this.SetID = this.props.SetID;

        this.LoadData = this.LoadDirectory.bind(this);
        this.OnBackClick = this.OnBackClick.bind(this);
        this.OnDirectoryClick = this.OnDirectoryClick.bind(this);
        this.OnScanDirClick = this.OnScanDirClick.bind(this);
        this.OnSortClick = this.OnSortClick.bind(this);

        //#endregion

        this.LoadDirectory();
    }

    //#endregion 

    //#region Events

    OnBackClick(sender) {
        this.props.ParentComponent.SetID(this.state.data.ParentID);

        console.log("OnBackClick " + this.state.data.ParentID);

        //this.state = { ID: new_id };
        this.LoadDirectory();
    }

    OnDirectoryClick(id) {
        this.props.ParentComponent.SetID(id);

        console.log("MoveToDirectory " + id);

        //this.state = { ID: new_id };
        this.LoadDirectory();
    }

    OnSortClick(sender) {
        let SortProperty = sender.target.attributes[0].value;

        let data = this.state.data;
        //debugger;
        data.items.sort(ArrayCompare(SortProperty, 1));
        this.setState({ data: data });
    }


    //#endregion

    //Загружает информацию о текущей папке
    LoadDirectory() {
        let ID = this.props.ParentComponent.GetID();
        console.log("LoadDirectory " + ID);

        this.fileExplorerServices.DirectoryGetItemsAsync(ID)
            .then(function (response) {
                response.json().then(function (data) {
                    this.setState({ data: data, ShoSelect: (this.props.ShoSelect && ID != -1 ? true : false)
                });
                }.bind(this));
            }.bind(this));
    }

    OnScanDirClick(sender) {
        let ID = this.props.ParentComponent.GetID();
        console.log("ScanDirectory " + ID);

        this.fileExplorerServices.ScanDirectoryAsync(ID).then(function (response) {
            response.json().then(function (data) {
                this.LoadData();;
            }.bind(this));
        }.bind(this));
    }

    //Получить ID данных выбранных строк
    GetSelectedID() {
        //debugger;
        return this.ChildRows.
            filter(e => e.IsCheked()).
            map(e => e.GetDataID());
    }

    render() {
        //this.ChildRows = [];
        let data = this.state.data;

        //Если данные не пусты
        if (JSON.stringify(data) !== '{}') {
            console.log("Data");

            return (
                <div>
                    <p>
                        <Link to={`/?ID=${data.ParentID}`}>
                            <button onClick={this.OnBackClick}>
                                l-  На уровень вверх - {data.ParentName}
                            </button>
                        </Link>
                    </p>
                    <p>{data.LogicPath}</p>
                    <p>
                        <button onClick={this.LoadData}>
                            Update
                         </button>
                        <button onClick={this.OnScanDirClick}>
                            Rescan
                         </button>
                    </p>


                    <table class="table">
                        <tr>
                            <th>
                                <button property="ID" onClick={this.OnSortClick}>ID</button>
                            </th>
                            {
                                this.state.ShoSelect
                                ? <th>Select</th>
                                : ""
                            }
                            <th>
                                <button property="Name" onClick={this.OnSortClick}>Name</button>
                            </th>
                            <th>
                                <button property="Type" onClick={this.OnSortClick}>Type</button>
                            </th>
                            <th>
                                <button property="Size" onClick={this.OnSortClick}>Size</button>
                            </th>
                        </tr>

                        {
                            data.items.map(function (elem, i, arr) {
                                return [
                                    <FileExplorerRow ref={row => {
                                        if (row != null) this.ChildRows[i] = row;
                                        else this.ChildRows.splice(i, 1);
                                    }}
                                        ShoSelect={this.state.ShoSelect}
                                        ID={i}
                                        data={elem}
                                        ParentComponent={this}
                                    />
                                ];
                            }.bind(this))
                        }
                    </table>
                </div>
            );
        }
        else {
            console.log("NoData");

            return (
                <div>
                    <p>NoData</p>
                </div>
            );
        }
    }
}