﻿
class FileExplorerRow extends React.Component {

    constructor(props) {
        super(props);
        console.log('FileExplorerRow start ' + this.props.ID);

        this.state = { ID: this.props.ID, Data: this.props.data, ShoSelect: this.props.ShoSelect };

        this.GetDate = this.GetDate.bind(this);
        this.GetRowID = this.GetRowID.bind(this);
        this.GetDataID = this.GetDataID.bind(this);
        this.IsCheked = this.IsCheked.bind(this);
        this.OnDirectoryClick = this.OnDirectoryClick.bind(this);
    }

    componentWillReceiveProps(nextProps) {
        this.props = nextProps;

        if (this.refs.Select != undefined)
            this.refs.Select.checked = false;

        this.setState({
            ID: this.props.ID,
            Data: this.props.data,
            ShoSelect: this.props.ShoSelect
        });
    }

    GetDate() {
        return this.state.Data;
    }

    GetRowID() {
        return this.state.ID;
    }
    GetDataID() {
        return this.state.Data.ID;
    }
    IsCheked() {
        if (this.refs.Select == undefined)
            return false;

        return this.refs.Select.checked;
    }


    OnDirectoryClick() {
        this.props.ParentComponent.OnDirectoryClick(this.GetDataID());
    }

    render() {
        let state = this.state;
        let elem = state.Data;

        return (
            <tr>
                <td>{elem.ID}</td>
                {state.ShoSelect
                    ?
                    <td>
                        <input ref="Select" type="checkbox" />
                    </td>
                    : ""
                }


                {(elem.Type === "RootDirectory" || elem.Type === "Directory")
                    ?
                    <td>
                        <Link to={`/?ID=${elem.ID}`}>
                            <Button id={elem.ID} onClick={this.OnDirectoryClick} variant="outline-dark">
                                {elem.Name}
                            </Button>
                        </Link>
                    </td>
                    : <td>{elem.Name}</td>
                }
                <td>{elem.Type}</td>
                <td>{elem.Size}</td>
            </tr>
        );

    }
}