﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


using Model.Entities.Files.Repo;
using Model.Entities.Base;
using Model.UnitsOfWork;

namespace Model.Entities.Users
{
    public enum EnumDefaultGroups
    {
        Администраторы,
        Модераторы,
        Пользователи,
        Анонимные
    }

    public class Repo_Group : BaseRepository<Group>
    {
        public readonly static string[] DefaultGroupsNames = new string[]
        {
            EnumDefaultGroups.Администраторы.ToString(),
            EnumDefaultGroups.Модераторы.ToString(),
            EnumDefaultGroups.Пользователи.ToString(),
            EnumDefaultGroups.Анонимные.ToString()
        };

        public override void RepoInit()
        {
            foreach (var elem in DefaultGroupsNames)
            {
                if (All_NoTrack.FirstOrDefault(e => e.Name == elem) == null)
                    Create(new Group() { Name = elem});
            }
        }
        public Repo_Group(UOW UOW) : base(UOW) { }

        public Group GetDefaultGroup(EnumDefaultGroups en)
        {
            return All.FirstOrDefault(e => e.Name == en.ToString()); ;
        }


        protected override void Validation_Create(Group elem)
        {
            if (All_NoTrack.FirstOrDefault(e => e.Name == elem.Name) != null)
                throw new Exception();
        }
        public override Group Create(Group elem)
        {
            UOW.Repo_SRootDirectory.All_NoTrack_List.ForEach(e =>
            {
                elem.DirectoryPermissions.AddOrUpdate(Permission.Factory_NoPermission(e));
            });            

            return base.Create(elem);
        }

        protected override void Validation_Update(Group old, Group elem)
        {
            //Изменение названия
            if (old.Name != elem.Name)
            {
                //Не менять название дефолтных групп
                if (DefaultGroupsNames.Contains(elem.Name))
                    throw new Exception();

                //Группа с таким именем уже существует
                if (All_NoTrack.FirstOrDefault(e => e.Name == elem.Name) != null)
                    throw new Exception();
            }
        }

        protected override void Validation_Delete(Group elem)
        {
            if (DefaultGroupsNames.Contains(elem.Name))
                throw new Exception();

            elem.Users.Clear();
        }


        public IEnumerable<Group> GetGroupWithDirectory(IEnumerable<Group> groups)
        {
            var RootDirs = UOW.Repo_SRootDirectory.All_List;

            groups.ToList().ForEach(e => 
            {
                e.DirectoryPermissions.Permissions.Values.ToList().ForEach(e2=> 
                {
                    e2.RootDirectory = RootDirs.
                    FirstOrDefault(e3 => e3.ID == e2.DirectoryID);
                });
            });

            return groups;
        }

    }
}

