﻿
import React from 'react';
import { Modal, Button } from 'react-bootstrap'

import Notification from '../../../Tools/Notification'

import FileExplorerServices from '../../../Services/FileExplorerServices'

import BaseControl from '../../BaseControl.jsx'
import FileExplorerControl from '../FileExplorer/FileExplorerControl.jsx'


export default class ExplorerActionsControl extends BaseControl {

    constructor(props) {
        super(props, "ExplorerActionsControl");

        this.state = { MoveWindowsShow: false }
        this.fileExplorerServices = new FileExplorerServices();

        this.GlobalState.MoveExplorer = {
            ID: this.GlobalState.MainExplorer.ID,
            ShoSelectColumn: false,
            ChangeEvent: "OnItemsChange_Move"
        };
    }


    OnDownloadClick(sender) {

        let selected = this.GlobalState.MainExplorer.
            ExplorerControl.GetSelectedID();

        selected.map((e) => {
            this.Log("OnDownload " + e);

            this.fileExplorerServices.OpenDownload(e);
        });
    }

    OnDeleteClick(sender) {

        let selected = this.GlobalState.MainExplorer.
            ExplorerControl.GetSelectedID();

        let promises = selected.map((e) => {
            this.Log("OnDelete " + e);
            return this.fileExplorerServices.DeleteAsync(e);
        });

        
        Promise.all(promises).then(function (data) {
            let Result = "";

            data.map(function (e) {
                Result += "Succese: " + e.Successe + " ResultMsg:" + e.ResMessage + " | ";
            });

            Notification.MesOk(Result, 'Move');

            this.EventRegister.
                EventAction(this.GlobalState.MainExplorer.ChangeEvent);
        }.bind(this));

    }


    OnMoveClick(sender) {
        let selected = this.GlobalState.MainExplorer.
            ExplorerControl.GetSelectedID();

        if (selected.length == 0)
            return;

        this.selected = selected;

        this.setState({ MoveWindowsShow: true });
    }

    OnCreateDirectoryClick(sender) {
        //debugger;
        let dirname = this.refs.DirectoryName.value;
        let id = this.GlobalState.MainExplorer.ID;

        this.fileExplorerServices.CreateDirectoryAsync(dirname, id).
            then(function (data) {
                this.EventRegister.
                    EventAction(this.GlobalState.MainExplorer.ChangeEvent);
                Notification.MesOk('Complete', 'CreateDir');
            }.bind(this));

        this.refs.DirectoryName.value = "";
    }


    OnMoveWindowCloseClick() {
        this.setState({ MoveWindowsShow: false });
    }

    OnMoveWindowClick() {

        if (this.GlobalState.MainExplorer.ID == this.GlobalState.MoveExplorer.ID) {
            this.setState({ MoveWindowsShow: false });
            return;
        }

        let promises = this.selected.map(function (e) {
            this.Log("OnMove " + e);
            return this.fileExplorerServices.
                MoveAsync(e, this.GlobalState.MoveExplorer.ID);
        }.bind(this));

        Promise.all(promises).then(function (data) {

            let Result = "";

            data.map(function (e){
                Result += "Succese: " + e.Successe + " ResultMsg:" + e.ResMessage + " | ";
            });
            
            //this.setState({ ResultMsg: Result });
            Notification.MesOk(Result, 'Move');
            this.EventRegister.
                EventAction(this.GlobalState.MainExplorer.ChangeEvent);
        }.bind(this));

        this.setState({ MoveWindowsShow: false });
    }


    render() {

        return (
            <div>
                <p>ExplorerControlPanel</p>

                <p>
                    <input ref="DirectoryName" />
                    <button onClick={this.OnCreateDirectoryClick}>CreateDirectory</button>
                </p>

                <table>
                    <thead>
                        <tr>
                            <th><button onClick={this.OnDownloadClick}>Скачать</button></th>
                            <th><button onClick={this.OnDeleteClick}>Удалить</button></th>
                            <th><button onClick={this.OnMoveClick}>Переместить</button></th>
                        </tr>
                    </thead>
                </table>

                <Modal ref="Modal"
                    show={this.state.MoveWindowsShow}
                    onHide={this.OnMoveWindowCloseClick}

                    size="lg"
                    aria-labelledby="contained-modal-title-vcenter"
                    centered
                >
                    <Modal.Header closeButton>
                        <Modal.Title>Select destination directory</Modal.Title>
                    </Modal.Header>
                    <Modal.Body>
                        <FileExplorerControl ref="FileExplorerControl"
                            ParentComponent={this}
                            CurrentDirectoryName={"MoveExplorer"}
                        />
                    </Modal.Body>
                    <Modal.Footer>
                        <Button variant="secondary" onClick={this.OnMoveWindowCloseClick}>
                            Cansel
                        </Button>
                        <Button variant="primary" onClick={this.OnMoveWindowClick}>
                            Move to directory
                        </Button>
                    </Modal.Footer>
                </Modal>
            </div>
        );

    }
}
