﻿
import React from 'react';

import Configuration from '../../Tools/Configuration'

import BaseControl from '../BaseControl.jsx'
import MenuControl from '../Controls/MenuControl.jsx'
import UserControl from '../Controls/UserControl.jsx'
import FileExplorerControl from '../Controls/FileExplorer/FileExplorerControl.jsx'
import ExplorerActionsControl from '../Controls/FileExplorer/ExplorerActionsControl.jsx'
import UploaderControl from '../Controls/FileExplorer/UploaderControl.jsx'
import BootstrapControl from '../Controls/BootstrapControl.jsx'

export default class FileExplorerPage extends BaseControl {

    constructor(props) {
        super(props, "FileExplorerPage");

        //Получить ID из url
        var url_ID = new URL(window.location.href).
            searchParams.get("ID");

        if (url_ID != null)
            this.GlobalState.MainExplorer = {
                ID: url_ID,
                ShoSelectColumn: true,
                ChangeEvent: "OnItemsChange_Main"
            };
        else
            this.GlobalState.MainExplorer = {
                ID: -1,
                ShoSelectColumn: true,
                ChangeEvent: "OnItemsChange_Main"
            };

        //this.EventRegister.EventAction("OnItemsChange");
    }

    OnRegistersClick() {
        let Global = this.GlobalState;
        let Controls = BaseControl.controlRegister;
        let Events = this.EventRegister;
        debugger;
    }

    render() {
        return (
            <div>
                <button onClick={this.OnRegistersClick}>Registers</button>

                <hr />
                <MenuControl ref="MenuControl"
                    ParentComponent={this}
                />
                <hr />
                <UserControl ref="UserControl"
                    ParentComponent={this}
                />

                <hr />
                <FileExplorerControl ref="FileExplorerControl"
                    ParentComponent={this}
                    //Параметры для того, чтобы можно было содержать 
                    //несколько элементов данного типа с разными дирректориями                   
                    CurrentDirectoryName={"MainExplorer"}            
                />
                <hr />
                {(this.GlobalState.MainExplorer.ID != Configuration.RooDirectoryID)
                    ?
                    <div>
                        <ExplorerActionsControl ref="ExplorerActionsControl"
                            ParentComponent={this}
                        />
                        <hr />
                        <UploaderControl ref="UploaderControl"
                            ParentComponent={this}
                        />
                        <hr />
                    </div>
                    : null
                }
                <hr />
                <BootstrapControl />
                <hr />

            </div>
        );
    }
}

