﻿
import ApiQuery from '../Tools/ApiQuery'


export default class UserServices {

    constructor() {
        this.URL_GetUsers = "api/User/GetUserList";
        this.URL_SetUsers = "api/User/SetUserList";

        //AutodecrementID
        this.ID = 0;
    }


    async GetUsersAsync() {
        return await ApiQuery(this.URL_GetUsers, "Post")
            .then(function (data) {
                if (data.Successe) {
                    this.Groups = data.Groups;
                }

                return data;
            }.bind(this));
    }

    async SetUsersAsync(users) {

        return await ApiQuery(this.URL_SetUsers, "Post", users)
            .then(function (data) {
                return data;
            }.bind(this));
    }



    CreateUser() {
        this.ID--;

        return {
            ID: this.ID,
            Name: "NewUser" + this.ID,
            Password: "QWERTY",
            Active: true,
            Changes: 2, //Create

            Groups: this.Groups.map((e) => {
                return {
                    ID: e.ID,
                    Name: e.Name,
                    EnterInGroup: (e.Name == "Пользователи") ? true : false
                };
            })
        };
    }
    CreateStubUser() {
        return {
            Users: [],
            ShoGroups: false,
            //Заглушка
            UserGroups: {
                ID: -1,
                Name: "",
                Password: "",
                Active: false,
                Changes: -1,
                Groups: [{
                    ID: -11,
                    Name: "",
                    EnterInGroup: false
                }]
            }
        }


    }
}
