﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Data.Entity;

using BLL.Base;
using Model.Entities.Users;
using Model.UnitsOfWork;
using Model.ViewModel;

namespace BLL.Services.Mapper
{
    public class UserMapper : BaseServices
    {
        public UserMapper(UOW UOW) : base(UOW) { }


        public List<GroupInfo> GroupToGroupInfo_ForUsers()
        {
            return UOW.Repo_Group.All_NoTrack_List.
                        Where(e => e.Name != EnumDefaultGroups.Анонимные.ToString()).
                        Select(e => new GroupInfo()
                        {
                            ID = e.ID,
                            Name = e.Name                            
                        }).ToList();
        }
        public List<RootDirInfo> RootDirs()
        {
            var groups = UOW.Repo_Group.
                GetGroupWithDirectory(UOW.Repo_Group.All_List);

            return new List<RootDirInfo>(groups.Select(e => new RootDirInfo()
            {
                ID = e.ID,
                Name = e.Name,
                CanDownload = false,
                CanOpen = false,
                CanUpload = false
            }));
        }


        public List<EditUserModel> UserToEditUser_List()
        {
            var users = UOW.Repo_User.All_NoTrack.
                Include(e => e.Groups).ToList();
            var groups = UOW.Repo_Group.All_NoTrack_List.
                Where(e => e.Name != EnumDefaultGroups.Анонимные.ToString());

            return users.Select(e => new EditUserModel()
            {
                ID = e.ID,
                Name = e.Login,
                Password = "",
                Changes = EnumChanges.NoChange,
                Active = e.IsActive,
                Groups = groups.Select(e2 => new GroupInfo()
                {
                    ID = e2.ID,
                    Name = e2.Name,
                    EnterInGroup = e.Groups.FirstOrDefault(e3 => e3.ID == e2.ID) != null
                }).ToList()
            }).ToList();
        }

        public List<(EditUserModel Edited, User DBUser)> EditUserToUser_List(List<EditUserModel> editUsers)
        {
            List<(EditUserModel Edited, User DBUser)> res = new List<(EditUserModel Edited, User DBUser)>(editUsers.Count());
            var groups = UOW.Repo_Group.All_List;

            foreach (var elem in editUsers)
            {
                var current_groups_id = elem.Groups.
                    Where(g => g.EnterInGroup).
                    Select(g => g.ID);

                User current_user = null;

                switch (elem.Changes)
                {
                    case EnumChanges.Create:
                        current_user = new User(elem.Name, elem.Password, elem.Active,
                            groups.Where(e => current_groups_id.Contains(e.ID)));
                        break;
                    case EnumChanges.Update:
                        current_user = UOW.Repo_User.All.
                            FirstOrDefault(e => e.ID == elem.ID);
                        current_user.Login = elem.Name;
                        current_user.Password = string.IsNullOrEmpty(elem.Password)
                            ? current_user.Password
                            : elem.Password;
                        current_user.IsActive = elem.Active;
                        current_user.Groups = new List<Group>(groups.
                            Where(e => current_groups_id.Contains(e.ID)));
                        break;
                    case EnumChanges.Delete:
                        current_user = UOW.Repo_User.All.
                            FirstOrDefault(e => e.ID == elem.ID);
                        break;
                }

                res.Add(new ValueTuple<EditUserModel, User>(elem, current_user));
            }

            return res;
        }


        public List<GroupInfo> GroupToGroupEditor()
        {
            var groups = UOW.Repo_Group.
                GetGroupWithDirectory(UOW.Repo_Group.All_List);

            return groups.Select(e => new GroupInfo()
            {
                ID = e.ID,
                Name = e.Name,
                RootDirInfos = e.DirectoryPermissions.Permissions.
                    Select(e2 => new RootDirInfo()
                    {
                        ID = e2.Value.DirectoryID,
                        Name = e2.Value.RootDirectory.Name,

                        CanDownload = e2.Value.CanDownload,
                        CanOpen = e2.Value.CanOpen,
                        CanUpload = e2.Value.CanUpload
                    }).ToList()
            }).ToList();
        }


    }
}
